import { Link } from 'react-router-dom';
import Navbar from '../../components/Navbar';
import Footer from '../../components/Footer';

const Terms = () => {
  return (
    <div className="pt-14 bg-[#f4f4f4]">
      {/* Hero Section */}
      <header className="py-20 bg-[#f4f4f4] border-b border-[#e0e0e0] relative overflow-hidden">
        <div
          className="absolute inset-0 z-0 opacity-5"
          style={{
            backgroundImage: 'linear-gradient(#161616 1px, transparent 1px), linear-gradient(to right, #161616 1px, transparent 1px)',
            backgroundSize: '50px 50px'
          }}
        ></div>

        <div className="bx--grid relative z-10">
          <div className="text-center">
            <h1 className="text-4xl font-light text-[#161616] mb-6 leading-tight tracking-tight">
              Terms of <span className="font-semibold text-[#0f62fe]">Service</span>
            </h1>
            <p className="text-lg text-[#6f6f6f]">Last updated: December 2025</p>
          </div>
        </div>
      </header>

      {/* Content */}
      <section className="py-24 bg-white border-b border-[#e0e0e0]">
        <div className="bx--grid">
          <div className="max-w-4xl mx-auto px-6">
            <div className="prose prose-lg max-w-none">
              <h2>1. Agreement to Terms</h2>
              <p>
                By registering for, accessing, or using any services provided by HostCraft ("we," "us," or "our"),
                you ("User," "Client," or "Customer") agree to be bound by these Terms of Service ("Terms").
                If you do not agree to these Terms, you must not access or use our services.
              </p>

              <h2>2. Account Eligibility</h2>
              <p>By registering, you represent and warrant that:</p>
              <ul className="list-disc pl-5 space-y-2 text-[#6f6f6f]">
                <li>You are at least 18 years of age or the age of majority in your jurisdiction.</li>
                <li>You have the authority to enter into a binding contract on behalf of yourself or the entity you represent.</li>
                <li>You will provide accurate, current, and complete registration information.</li>
                <li>You serve a country not currently embargoed by the US Government or European Union.</li>
              </ul>

              <h2>3. Services & SLAs</h2>
              <p>
                <strong>Service Availability:</strong> We strive to maintain a 99.9% network uptime. Credit is provided
                for downtime exceeding this threshold, excluding planned maintenance.
              </p>
              <p>
                <strong>Support:</strong> Support is valid for our infrastructure only (network, hardware, power).
                We do not provide management for your software, scripts, or OS unless a management package is purchased.
              </p>
              <p>
                <strong>Backups:</strong> While we may maintain internal disaster recovery backups, you are solely
                responsible for maintaining backups of your own data. HostCraft is not liable for data loss.
              </p>

              <h2>4. Payments & Billing</h2>
              <p>
                <strong>Billing Cycle:</strong> Services are billed in advance on a monthly, quarterly, or annual basis.
              </p>
              <p>
                <strong>Late Payments:</strong> Invoices generated 7 days before due date. Services may be suspended
                3 days after the due date if unpaid. Termination occurs 14 days after non-payment.
              </p>
              <p>
                <strong>Chargebacks:</strong> Any chargeback or dispute filed without prior communication will result
                in immediate account termination and permanent ban.
              </p>

              <h2>5. Cancellations & Refunds</h2>
              <p>
                You may cancel services at any time via the billing portal. Cancellation requests must be submitted
                at least 24 hours prior to renewal.
              </p>
              <p>
                Refunds are governed by our{' '}
                <Link to="/legal/refund" className="text-[#0f62fe] hover:underline">
                  Refund Policy
                </Link>
                . Generally, a 7-day money-back guarantee applies to new services, excluding crypto payments and licenses.
              </p>

              <h2>6. Acceptable Use</h2>
              <p>
                You agree to use our services in compliance with our{' '}
                <Link to="/legal/aup" className="text-[#0f62fe] hover:underline">
                  Acceptable Use Policy (AUP)
                </Link>
                . Strictly prohibited activities include hosting child exploitation material, phishing, DDoS attacks
                (sending), and malware distribution.
              </p>

              <h2>7. Limitation of Liability</h2>
              <p>
                HostCraft shall not be liable for any indirect, incidental, special, consequential, or punitive damages,
                including loss of profits, data, or goodwill, arising out of:
              </p>
              <ul className="list-disc pl-5 space-y-2 text-[#6f6f6f]">
                <li>Service interruptions or downtime.</li>
                <li>Data loss or corruption.</li>
                <li>Unauthorized access to your data by third parties.</li>
              </ul>

              <h2>8. Modifications</h2>
              <p>
                We reserve the right to modify these Terms at any time. We will notify clients of significant changes
                via email or dashboard notification. Continued use of services constitutes acceptance of the modified Terms.
              </p>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
};

export default Terms;
