import { Link } from 'react-router-dom';
import Navbar from '../../components/Navbar';
import Footer from '../../components/Footer';

const Refund = () => {
  return (
    <div className="pt-14 bg-[#f4f4f4]">
      {/* Hero Section */}
      <header className="py-20 bg-[#f4f4f4] border-b border-[#e0e0e0] relative overflow-hidden">
        <div
          className="absolute inset-0 z-0 opacity-5"
          style={{
            backgroundImage: 'linear-gradient(#161616 1px, transparent 1px), linear-gradient(to right, #161616 1px, transparent 1px)',
            backgroundSize: '50px 50px'
          }}
        ></div>

        <div className="bx--grid relative z-10">
          <div className="text-center">
            <h1 className="text-4xl font-light text-[#161616] mb-6 leading-tight tracking-tight">
              Refund <span className="font-semibold text-[#0f62fe]">Policy</span>
            </h1>
            <p className="text-lg text-[#6f6f6f]">Last updated: December 2025</p>
          </div>
        </div>
      </header>

      {/* Content */}
      <section className="py-24 bg-white border-b border-[#e0e0e0]">
        <div className="bx--grid">
          <div className="max-w-4xl mx-auto px-6">
            <div className="prose prose-lg max-w-none">
              <h2>1. Money-Back Guarantee</h2>
              <p>
                HostCraft offers a <strong>7-day money-back guarantee</strong> on all new VPS services. If you are not
                satisfied with your service within the first 7 days, you may request a full refund.
              </p>

              <h2>2. Eligibility</h2>
              <p>To be eligible for a refund, you must:</p>
              <ul className="list-disc pl-5 space-y-2 text-[#6f6f6f]">
                <li>Be a first-time customer for the service being refunded.</li>
                <li>Request the refund within 7 days of the initial payment.</li>
                <li>Not have violated our Terms of Service or Acceptable Use Policy.</li>
                <li>Have paid using a refundable payment method (see exclusions below).</li>
              </ul>

              <h2>3. Exclusions</h2>
              <p>The following are <strong>not eligible</strong> for refunds:</p>
              <ul className="list-disc pl-5 space-y-2 text-[#6f6f6f]">
                <li><strong>Cryptocurrency Payments:</strong> Payments made via Bitcoin, USDT, ETH, or other cryptocurrencies.</li>
                <li><strong>Software Licenses:</strong> Windows licenses, cPanel, Plesk, or other third-party software.</li>
                <li><strong>Domain Registrations:</strong> Domain names are non-refundable once registered.</li>
                <li><strong>Setup Fees:</strong> One-time setup or migration fees are non-refundable.</li>
                <li><strong>Renewals:</strong> Renewal payments are not eligible for the money-back guarantee.</li>
                <li><strong>Abuse/TOS Violations:</strong> Services terminated due to policy violations.</li>
              </ul>

              <h2>4. How to Request a Refund</h2>
              <p>To request a refund:</p>
              <ol className="list-decimal pl-5 space-y-2 text-[#6f6f6f]">
                <li>Log in to your account and open a support ticket.</li>
                <li>Select "Billing & Sales" as the department.</li>
                <li>Clearly state your refund request and the reason for cancellation.</li>
                <li>Include the invoice number and service details.</li>
              </ol>
              <p>
                Refunds are typically processed within 3-7 business days. Refunds will be credited to the original
                payment method.
              </p>

              <h2>5. Partial Refunds</h2>
              <p>
                Partial refunds may be issued at our discretion for services used beyond the 7-day guarantee period,
                typically calculated as a pro-rata amount based on unused time.
              </p>

              <h2>6. Service Credits</h2>
              <p>
                In some cases, we may offer service credits instead of cash refunds. Service credits can be used toward
                future purchases and do not expire. Service credits cannot be converted to cash.
              </p>

              <h2>7. Chargebacks</h2>
              <p>
                Filing a chargeback or payment dispute without first contacting our support team will result in immediate
                account suspension. We encourage you to contact us first to resolve any billing issues.
              </p>

              <h2>8. Contact</h2>
              <p>
                For billing inquiries or refund requests, please contact us at{' '}
                <a href="mailto:billing@hostcraft.site" className="text-[#0f62fe] hover:underline">
                  billing@hostcraft.site
                </a>{' '}
                or open a{' '}
                <Link to="/support/ticket" className="text-[#0f62fe] hover:underline">
                  support ticket
                </Link>
                .
              </p>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
};

export default Refund;
