import { Link } from 'react-router-dom';
import Navbar from '../../components/Navbar';
import Footer from '../../components/Footer';

const Privacy = () => {
  return (
    <div className="pt-14 bg-[#f4f4f4]">
      {/* Hero Section */}
      <header className="py-20 bg-[#f4f4f4] border-b border-[#e0e0e0] relative overflow-hidden">
        <div
          className="absolute inset-0 z-0 opacity-5"
          style={{
            backgroundImage: 'linear-gradient(#161616 1px, transparent 1px), linear-gradient(to right, #161616 1px, transparent 1px)',
            backgroundSize: '50px 50px'
          }}
        ></div>

        <div className="bx--grid relative z-10">
          <div className="text-center">
            <h1 className="text-4xl font-light text-[#161616] mb-6 leading-tight tracking-tight">
              Privacy <span className="font-semibold text-[#0f62fe]">Policy</span>
            </h1>
            <p className="text-lg text-[#6f6f6f]">Last updated: December 2025</p>
          </div>
        </div>
      </header>

      {/* Content */}
      <section className="py-24 bg-white border-b border-[#e0e0e0]">
        <div className="bx--grid">
          <div className="max-w-4xl mx-auto px-6">
            <div className="prose prose-lg max-w-none">
              <h2>1. Information We Collect</h2>
              <p>We collect information you provide directly to us, such as when you create an account, make a purchase, or contact support:</p>
              <ul className="list-disc pl-5 space-y-2 text-[#6f6f6f]">
                <li><strong>Account Information:</strong> Name, email address, username, password.</li>
                <li><strong>Billing Information:</strong> Payment method details, billing address, transaction history.</li>
                <li><strong>Service Data:</strong> Server configurations, IP addresses, usage logs.</li>
                <li><strong>Support Communications:</strong> Ticket contents, chat logs, email correspondence.</li>
              </ul>

              <h2>2. How We Use Your Information</h2>
              <p>We use the information we collect to:</p>
              <ul className="list-disc pl-5 space-y-2 text-[#6f6f6f]">
                <li>Provide, maintain, and improve our services.</li>
                <li>Process transactions and send related information.</li>
                <li>Send technical notices, updates, and support messages.</li>
                <li>Respond to your comments, questions, and customer service requests.</li>
                <li>Monitor and analyze trends, usage, and activities in connection with our services.</li>
                <li>Detect, investigate, and prevent fraudulent transactions and abuse.</li>
              </ul>

              <h2>3. Information Sharing</h2>
              <p>We do not sell or rent your personal information to third parties. We may share information with:</p>
              <ul className="list-disc pl-5 space-y-2 text-[#6f6f6f]">
                <li><strong>Service Providers:</strong> Third-party vendors who assist in providing our services (payment processors, data centers).</li>
                <li><strong>Legal Requirements:</strong> When required by law or to respond to valid legal process.</li>
                <li><strong>Protection of Rights:</strong> When necessary to protect our rights, privacy, safety, or property.</li>
              </ul>

              <h2>4. Data Security</h2>
              <p>
                We implement appropriate technical and organizational measures to protect your personal information against
                unauthorized access, alteration, disclosure, or destruction. This includes encryption, access controls,
                and regular security assessments.
              </p>

              <h2>5. Data Retention</h2>
              <p>
                We retain your personal information for as long as your account is active or as needed to provide you services.
                We may retain certain information as required by law or for legitimate business purposes.
              </p>

              <h2>6. Your Rights</h2>
              <p>You have the right to:</p>
              <ul className="list-disc pl-5 space-y-2 text-[#6f6f6f]">
                <li>Access and receive a copy of your personal data.</li>
                <li>Request correction of inaccurate data.</li>
                <li>Request deletion of your data (subject to legal requirements).</li>
                <li>Object to processing of your data.</li>
                <li>Request data portability.</li>
              </ul>

              <h2>7. Cookies</h2>
              <p>
                We use cookies and similar technologies to collect information about your browsing activities and to
                distinguish you from other users. You can control cookies through your browser settings.
              </p>

              <h2>8. Changes to This Policy</h2>
              <p>
                We may update this Privacy Policy from time to time. We will notify you of any changes by posting the
                new Privacy Policy on this page and updating the "Last updated" date.
              </p>

              <h2>9. Contact Us</h2>
              <p>
                If you have any questions about this Privacy Policy, please contact us at{' '}
                <a href="mailto:privacy@hostcraft.site" className="text-[#0f62fe] hover:underline">
                  privacy@hostcraft.site
                </a>
                .
              </p>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
};

export default Privacy;
