import { Link } from 'react-router-dom';
import Navbar from '../../components/Navbar';
import Footer from '../../components/Footer';

const AUP = () => {
  return (
    <div className="pt-14 bg-[#f4f4f4]">
      {/* Hero Section */}
      <header className="py-20 bg-[#f4f4f4] border-b border-[#e0e0e0] relative overflow-hidden">
        <div
          className="absolute inset-0 z-0 opacity-5"
          style={{
            backgroundImage: 'linear-gradient(#161616 1px, transparent 1px), linear-gradient(to right, #161616 1px, transparent 1px)',
            backgroundSize: '50px 50px'
          }}
        ></div>

        <div className="bx--grid relative z-10">
          <div className="text-center">
            <h1 className="text-4xl font-light text-[#161616] mb-6 leading-tight tracking-tight">
              Acceptable Use <span className="font-semibold text-[#0f62fe]">Policy</span>
            </h1>
            <p className="text-lg text-[#6f6f6f]">Last updated: December 2025</p>
          </div>
        </div>
      </header>

      {/* Content */}
      <section className="py-24 bg-white border-b border-[#e0e0e0]">
        <div className="bx--grid">
          <div className="max-w-4xl mx-auto px-6">
            <div className="prose prose-lg max-w-none">
              <h2>1. Purpose</h2>
              <p>
                This Acceptable Use Policy (AUP) describes prohibited uses of HostCraft services. The examples in this
                policy are not exhaustive. We may modify this policy at any time by posting a revised version.
              </p>

              <h2>2. Prohibited Content</h2>
              <p>You may not use our services to host, distribute, or link to:</p>
              <ul className="list-disc pl-5 space-y-2 text-[#6f6f6f]">
                <li>Child sexual abuse material (CSAM) or any content that exploits minors.</li>
                <li>Content that promotes terrorism or violent extremism.</li>
                <li>Malware, viruses, trojans, or other malicious software.</li>
                <li>Phishing websites or fraudulent content.</li>
                <li>Content that infringes on intellectual property rights.</li>
                <li>Content that is defamatory, harassing, or discriminatory.</li>
              </ul>

              <h2>3. Prohibited Activities</h2>
              <p>You may not use our services to:</p>
              <ul className="list-disc pl-5 space-y-2 text-[#6f6f6f]">
                <li><strong>Launch DDoS Attacks:</strong> Initiating denial-of-service attacks against any target.</li>
                <li><strong>Network Abuse:</strong> Port scanning, network probing, or unauthorized access attempts.</li>
                <li><strong>Spam:</strong> Sending unsolicited bulk email or messages.</li>
                <li><strong>Cryptomining:</strong> Unauthorized cryptocurrency mining activities.</li>
                <li><strong>Proxying Abuse:</strong> Operating open proxies for malicious purposes.</li>
                <li><strong>Resource Abuse:</strong> Intentionally overloading shared resources.</li>
              </ul>

              <h2>4. Security</h2>
              <p>You are responsible for:</p>
              <ul className="list-disc pl-5 space-y-2 text-[#6f6f6f]">
                <li>Maintaining the security of your account credentials.</li>
                <li>Keeping your software and operating systems updated.</li>
                <li>Implementing appropriate firewall rules and access controls.</li>
                <li>Monitoring your services for unauthorized access or misuse.</li>
              </ul>

              <h2>5. Enforcement</h2>
              <p>
                Upon becoming aware of a violation of this AUP, we may, at our sole discretion:
              </p>
              <ul className="list-disc pl-5 space-y-2 text-[#6f6f6f]">
                <li>Issue a warning.</li>
                <li>Suspend or terminate the offending service without notice.</li>
                <li>Suspend or terminate your entire account.</li>
                <li>Report the activity to relevant law enforcement authorities.</li>
              </ul>

              <h2>6. Reporting Violations</h2>
              <p>
                To report a violation of this AUP, please contact{' '}
                <a href="mailto:abuse@hostcraft.site" className="text-[#0f62fe] hover:underline">
                  abuse@hostcraft.site
                </a>{' '}
                or open a support ticket. Please include as much detail as possible, including IP addresses, timestamps,
                and relevant logs.
              </p>

              <h2>7. No Liability</h2>
              <p>
                HostCraft is not responsible for the content hosted by customers. We act only as a hosting provider and
                will respond to valid takedown requests and abuse reports in accordance with applicable laws.
              </p>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
};

export default AUP;
