import { useState } from 'react';
import { Link } from 'react-router-dom';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faCheck, faShieldHalved, faHeadset, faBolt } from '@fortawesome/free-solid-svg-icons';
import Navbar from '../components/Navbar';
import Footer from '../components/Footer';

const PricingVPS = () => {
  const [pricingPeriod, setPricingPeriod] = useState('monthly');

  const pricingPlans = [
    {
      name: 'Starter',
      description: 'Perfect for personal projects',
      monthlyPrice: '499',
      yearlyPrice: '4999',
      features: [
        '2 vCPU Cores',
        '4GB DDR4 RAM',
        '50GB NVMe SSD',
        '1Gbps Network',
        'Path.net DDoS Protection',
        'Full Root Access',
        'Windows/Linux OS'
      ],
      popular: false,
      color: '#0f62fe'
    },
    {
      name: 'Developer',
      description: 'Best for development & testing',
      monthlyPrice: '999',
      yearlyPrice: '9999',
      features: [
        '4 vCPU Cores',
        '8GB DDR4 RAM',
        '100GB NVMe SSD',
        '1Gbps Network',
        'Path.net DDoS Protection',
        'Full Root Access',
        'Windows/Linux OS',
        'Priority Support'
      ],
      popular: true,
      color: '#0f62fe'
    },
    {
      name: 'Business',
      description: 'For production workloads',
      monthlyPrice: '1999',
      yearlyPrice: '19999',
      features: [
        '8 vCPU Cores',
        '16GB DDR4 RAM',
        '200GB NVMe SSD',
        '1Gbps Network',
        'Path.net DDoS Protection',
        'Full Root Access',
        'Windows/Linux OS',
        'Priority Support',
        'Weekly Backups'
      ],
      popular: false,
      color: '#8a3ffc'
    },
    {
      name: 'Enterprise',
      description: 'Maximum performance',
      monthlyPrice: '3999',
      yearlyPrice: '39999',
      features: [
        '16 vCPU Cores',
        '32GB DDR4 RAM',
        '400GB NVMe SSD',
        '1Gbps Network',
        'Path.net DDoS Protection',
        'Full Root Access',
        'Windows/Linux OS',
        'Dedicated Support',
        'Daily Backups',
        'SLA Guarantee'
      ],
      popular: false,
      color: '#24a148'
    }
  ];

  const includedFeatures = [
    { icon: faShieldHalved, title: 'DDoS Protection', description: '12Tbps+ Path.net protection included' },
    { icon: faHeadset, title: '24/7 Support', description: 'Engineering team always available' },
    { icon: faBolt, title: 'Instant Setup', description: 'Deploy in under 60 seconds' }
  ];

  return (
    <div className="pt-14 bg-[#f4f4f4]">
      {/* Hero Section */}
      <section className="bg-[#161616] py-20 border-b border-[#393939] relative overflow-hidden">
        {/* Technical Grid Pattern */}
        <div
          className="absolute inset-0 z-0 opacity-10 pointer-events-none"
          style={{
            backgroundImage: 'linear-gradient(#ffffff 1px, transparent 1px), linear-gradient(to right, #ffffff 1px, transparent 1px)',
            backgroundSize: '40px 40px'
          }}
        ></div>

        <div className="bx--grid relative z-10">
          <div className="max-w-3xl mx-auto text-center">
            <div className="inline-flex items-center gap-2 px-3 py-1 bg-[#0f62fe]/10 border border-[#0f62fe] text-[#0f62fe] text-xs font-bold uppercase tracking-wider mb-6 rounded-full">
              VPS Hosting
            </div>
            <h1 className="text-4xl md:text-5xl font-light text-white mb-6 tracking-tight">
              High Performance <span className="font-bold text-[#0f62fe]">VPS</span> Solutions
            </h1>
            <p className="text-lg text-[#a8a8a8] mb-8">
              Enterprise-grade virtual private servers powered by Dual Xeon processors,
              NVMe storage, and 12Tbps+ DDoS protection.
            </p>

            {/* Pricing Toggle */}
            <div className="inline-flex items-center bg-[#262626] rounded-lg p-1">
              <button
                onClick={() => setPricingPeriod('monthly')}
                className={`px-6 py-2 rounded-md text-sm font-bold transition ${
                  pricingPeriod === 'monthly'
                    ? 'bg-white text-[#161616] shadow'
                    : 'text-[#a8a8a8] hover:text-white'
                }`}
              >
                Monthly
              </button>
              <button
                onClick={() => setPricingPeriod('yearly')}
                className={`px-6 py-2 rounded-md text-sm font-bold transition ${
                  pricingPeriod === 'yearly'
                    ? 'bg-white text-[#161616] shadow'
                    : 'text-[#a8a8a8] hover:text-white'
                }`}
              >
                Yearly <span className="text-[#24a148] text-xs ml-1">Save 15%</span>
              </button>
            </div>
          </div>
        </div>
      </section>

      {/* Pricing Cards */}
      <section className="py-20">
        <div className="bx--grid">
          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
            {pricingPlans.map((plan, index) => (
              <div
                key={index}
                className={`plan-card relative bg-white border rounded-xl p-6 ${
                  plan.popular ? 'border-[#0f62fe] shadow-xl ring-2 ring-[#0f62fe]' : 'border-[#e0e0e0]'
                }`}
              >
                {plan.popular && (
                  <div className="absolute -top-3 left-1/2 -translate-x-1/2 px-4 py-1 bg-[#0f62fe] text-white text-xs font-bold rounded-full uppercase tracking-wider">
                    Most Popular
                  </div>
                )}

                <div className="mb-6">
                  <h3 className="text-xl font-bold text-[#161616]">{plan.name}</h3>
                  <p className="text-sm text-[#6f6f6f]">{plan.description}</p>
                </div>

                <div className="mb-6">
                  <span className="text-4xl font-bold text-[#161616]">
                    ₹{pricingPeriod === 'monthly' ? plan.monthlyPrice : plan.yearlyPrice}
                  </span>
                  <span className="text-[#6f6f6f]">/{pricingPeriod === 'monthly' ? 'mo' : 'yr'}</span>
                </div>

                <ul className="space-y-3 mb-6">
                  {plan.features.map((feature, idx) => (
                    <li key={idx} className="flex items-center gap-2 text-sm text-[#525252]">
                      <FontAwesomeIcon icon={faCheck} className="text-[#24a148]" />
                      {feature}
                    </li>
                  ))}
                </ul>

                <button
                  className={`w-full py-3 font-bold rounded transition ${
                    plan.popular
                      ? 'bg-[#0f62fe] text-white hover:bg-[#0043ce]'
                      : 'bg-[#f4f4f4] text-[#161616] hover:bg-[#e0e0e0] border border-[#e0e0e0]'
                  }`}
                >
                  Order Now
                </button>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Included Features */}
      <section className="py-16 bg-white border-y border-[#e0e0e0]">
        <div className="bx--grid">
          <div className="text-center mb-12">
            <h2 className="text-2xl font-bold text-[#161616] mb-2">Included with All Plans</h2>
            <p className="text-[#6f6f6f]">Every VPS comes with these features at no extra cost</p>
          </div>

          <div className="grid md:grid-cols-3 gap-8">
            {includedFeatures.map((feature, index) => (
              <div key={index} className="text-center">
                <div className="w-16 h-16 bg-[#0f62fe]/10 text-[#0f62fe] rounded-full flex items-center justify-center mx-auto mb-4">
                  <FontAwesomeIcon icon={feature.icon} className="text-2xl" />
                </div>
                <h3 className="font-bold text-[#161616] mb-2">{feature.title}</h3>
                <p className="text-sm text-[#6f6f6f]">{feature.description}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Specifications Table */}
      <section className="py-20">
        <div className="bx--grid">
          <div className="max-w-4xl mx-auto">
            <h2 className="text-2xl font-bold text-[#161616] mb-8 text-center">Technical Specifications</h2>

            <div className="bg-white border border-[#e0e0e0] rounded-lg overflow-hidden">
              <table className="w-full">
                <thead>
                  <tr className="bg-[#f4f4f4] border-b border-[#e0e0e0]">
                    <th className="px-6 py-4 text-left text-sm font-bold text-[#161616]">Feature</th>
                    <th className="px-6 py-4 text-left text-sm font-bold text-[#161616]">Specification</th>
                  </tr>
                </thead>
                <tbody>
                  {[
                    ['Processor', 'Dual Intel Xeon E5-2680 v4 (28 cores)'],
                    ['Virtualization', 'KVM with dedicated vCPU allocation'],
                    ['Memory', 'DDR4 ECC RAM (up to 128GB/node)'],
                    ['Storage', 'Samsung PM983 NVMe in RAID-10'],
                    ['Network', '1Gbps dedicated with unlimited bandwidth'],
                    ['DDoS Protection', 'Path.net 12Tbps+ Layer 3/4/7'],
                    ['Operating Systems', 'Windows Server 2019/2022/2025, Ubuntu, Debian, CentOS'],
                    ['Control Panel', 'Virtualizor with VNC console access'],
                    ['Locations', 'Mumbai (IN), Singapore (SG)']
                  ].map(([feature, spec], index) => (
                    <tr key={index} className="border-b border-[#e0e0e0] last:border-0">
                      <td className="px-6 py-4 text-sm font-medium text-[#161616]">{feature}</td>
                      <td className="px-6 py-4 text-sm text-[#525252]">{spec}</td>
                    </tr>
                  ))}
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 bg-[#161616]">
        <div className="bx--grid">
          <div className="max-w-3xl mx-auto text-center">
            <h2 className="text-3xl font-light text-white mb-4">
              Need a <span className="font-bold text-[#0f62fe]">Custom</span> Solution?
            </h2>
            <p className="text-[#a8a8a8] mb-8">
              Contact our sales team for custom configurations, dedicated servers, or enterprise requirements.
            </p>
            <div className="flex flex-wrap justify-center gap-4">
              <Link
                to="/support"
                className="px-8 py-4 bg-white text-[#161616] font-bold rounded hover:bg-[#0f62fe] hover:text-white transition"
              >
                Contact Sales
              </Link>
              <Link
                to="/docs"
                className="px-8 py-4 border border-[#525252] text-[#a8a8a8] hover:text-white hover:border-white font-bold rounded transition"
              >
                View Documentation
              </Link>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
};

export default PricingVPS;
