import { useState, useEffect } from 'react';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faWindows, faUbuntu } from '@fortawesome/free-brands-svg-icons';
import { faDesktop } from '@fortawesome/free-solid-svg-icons';

const VPSCard = () => {
  const [currentOS, setCurrentOS] = useState(0);
  const [isAnimating, setIsAnimating] = useState(false);

  const operatingSystems = [
    {
      icon: faWindows,
      title: 'Windows Server 2022',
      subtitle: 'Elite VPS Interface',
      bgColor: 'bg-blue-10',
      textColor: 'text-blue-60',
      borderColor: 'border-blue-20'
    },
    {
      icon: faUbuntu,
      title: 'Ubuntu 22.04 LTS',
      subtitle: 'Server x64',
      bgColor: 'bg-orange-10',
      textColor: 'text-orange-60',
      borderColor: 'border-orange-20'
    },
    {
      icon: faWindows,
      title: 'Windows Server 2019',
      subtitle: 'Datacenter x64',
      bgColor: 'bg-blue-10',
      textColor: 'text-blue-60',
      borderColor: 'border-blue-20'
    },
    {
      icon: faUbuntu,
      title: 'Ubuntu 24.04 LTS',
      subtitle: 'Server x64',
      bgColor: 'bg-orange-10',
      textColor: 'text-orange-60',
      borderColor: 'border-orange-20'
    },
    {
      icon: faWindows,
      title: 'Windows Server 2025',
      subtitle: 'Datacenter x64',
      bgColor: 'bg-blue-10',
      textColor: 'text-blue-60',
      borderColor: 'border-blue-20'
    }
  ];

  useEffect(() => {
    const interval = setInterval(() => {
      setIsAnimating(true);
      setTimeout(() => {
        setCurrentOS((prev) => (prev + 1) % operatingSystems.length);
        setIsAnimating(false);
      }, 500);
    }, 3500);

    return () => clearInterval(interval);
  }, []);

  const os = operatingSystems[currentOS];

  return (
    <div className="relative z-10 transform transition hover:-translate-y-1 duration-500">
      {/* Decorative Blob */}
      <div className="absolute -inset-1 bg-gradient-to-r from-blue-60 to-purple-60 rounded-2xl blur opacity-30 animate-pulse"></div>

      <div className="bg-black border border-gray-80 rounded-xl shadow-2xl overflow-hidden relative">
        {/* Card Header - macOS style */}
        <div className="bg-gray-10 p-4 border-b border-gray-20 flex justify-between items-center">
          <div className="flex items-center gap-3">
            <div className="w-3 h-3 rounded-full bg-red-50"></div>
            <div className="w-3 h-3 rounded-full bg-yellow-40"></div>
            <div className="w-3 h-3 rounded-full bg-green-40"></div>
          </div>
          <div className="text-xs font-mono text-gray-50">vchcloud-console</div>
        </div>

        {/* Card Body */}
        <div className="p-8">
          {/* Top Row: OS & Status */}
          <div className="flex justify-between items-start mb-8">
            <div
              className={`flex items-center gap-4 transition-all duration-500 ${
                isAnimating ? 'opacity-0 transform scale-95 -translate-y-2' : 'opacity-100 transform scale-100 translate-y-0'
              }`}
            >
              <div
                className={`w-16 h-16 ${os.bgColor} rounded-lg flex items-center justify-center ${os.textColor} text-3xl shadow-sm border ${os.borderColor} transition-colors duration-500`}
              >
                <FontAwesomeIcon icon={os.icon} className="transform transition-all duration-500 ease-out" />
              </div>
              <div>
                <h3 className="text-xl font-bold text-white transform transition-all duration-500 delay-100 ease-out">
                  {os.title}
                </h3>
                <p className="text-sm text-gray-40 transform transition-all duration-500 delay-100 ease-out">
                  {os.subtitle}
                </p>
              </div>
            </div>
            <div className="px-3 py-1 bg-green-10 text-green-60 text-xs font-bold rounded-full flex items-center gap-2 border border-green-20">
              <span className="relative flex h-2 w-2">
                <span className="animate-ping absolute inline-flex h-full w-full rounded-full bg-green-50 opacity-75"></span>
                <span className="relative inline-flex rounded-full h-2 w-2 bg-green-60"></span>
              </span>
              ONLINE
            </div>
          </div>

          {/* Specs Grid */}
          <div className="grid grid-cols-2 gap-4 mb-8">
            <div className="p-4 bg-white/5 rounded-lg border border-gray-80">
              <p className="text-[10px] uppercase text-gray-50 font-bold mb-1">Location</p>
              <p className="text-sm font-bold text-white flex items-center gap-2">
                <span className="text-lg">IN</span> Mumbai, IN
              </p>
            </div>
            <div className="p-4 bg-white/5 rounded-lg border border-gray-80">
              <p className="text-[10px] uppercase text-gray-50 font-bold mb-1">IP Address</p>
              <p className="text-sm font-bold text-white font-mono">103.21.x.x</p>
            </div>
            <div className="p-4 bg-white/5 rounded-lg border border-gray-80">
              <p className="text-[10px] uppercase text-gray-50 font-bold mb-1">RAM</p>
              <p className="text-sm font-bold text-white">32 GB DDR4</p>
            </div>
            <div className="p-4 bg-white/5 rounded-lg border border-gray-80">
              <p className="text-[10px] uppercase text-gray-50 font-bold mb-1">Network</p>
              <p className="text-sm font-bold text-blue-60">10 Gbps</p>
            </div>
          </div>

          {/* Connect Button */}
          <button className="w-full py-4 bg-blue-60 hover:bg-blue-70 text-white font-bold rounded-lg shadow-lg shadow-blue-60/20 transition flex items-center justify-center gap-3">
            <FontAwesomeIcon icon={faDesktop} />
            Connect via RDP
          </button>
        </div>
      </div>
    </div>
  );
};

export default VPSCard;
