import { Link } from 'react-router-dom';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faArrowRight, faChevronRight } from '@fortawesome/free-solid-svg-icons';
import { faDiscord, faFacebook, faInstagram } from '@fortawesome/free-brands-svg-icons';

const Footer = () => {
  return (
    <footer className="bg-[#0f0f0f] text-gray-30 pt-24 pb-12 border-t border-gray-80 relative overflow-hidden font-sans">
      {/* Technical Background */}
      <div
        className="absolute inset-0 opacity-[0.03] pointer-events-none"
        style={{
          backgroundImage: 'linear-gradient(#333 1px, transparent 1px), linear-gradient(to right, #333 1px, transparent 1px)',
          backgroundSize: '40px 40px'
        }}
      ></div>

      <div className="bx--grid relative z-10">
        {/* Top CTA Box */}
        <div className="bg-gray-100 border border-gray-80 p-8 md:p-12 rounded-xl flex flex-col md:flex-row items-center justify-between gap-8 mb-20 relative overflow-hidden group">
          {/* Glow Effect */}
          <div className="absolute top-0 right-0 w-64 h-64 bg-blue-60/10 blur-[100px] pointer-events-none transition duration-500 group-hover:bg-blue-60/20"></div>

          <div className="max-w-xl relative z-10">
            <h2 className="text-2xl md:text-3xl font-light text-white mb-3">
              Ready to <span className="text-blue-40 font-bold">Deploy?</span>
            </h2>
            <p className="text-gray-50 text-base leading-relaxed">
              Launch your high-performance RDP instance in under 60 seconds.
              Dual-Socket power, instant activation.
            </p>
          </div>

          <div className="flex flex-col sm:flex-row gap-4 w-full md:w-auto relative z-10">
            <Link
              to="/pricing/vps"
              className="px-8 py-4 bg-white text-gray-100 hover:bg-blue-60 hover:text-white font-bold transition-all shadow-lg rounded text-center min-w-[160px]"
            >
              Get Started
            </Link>
            <Link
              to="/support"
              className="px-8 py-4 border border-gray-60 text-gray-40 hover:text-white hover:border-white font-bold transition-all rounded text-center min-w-[160px]"
            >
              Talk to Sales
            </Link>
          </div>
        </div>

        {/* Main Navigation Grid */}
        <div className="grid grid-cols-2 md:grid-cols-12 gap-12 mb-20">
          {/* Brand Column (Span 4) */}
          <div className="col-span-2 md:col-span-4">
            <Link to="/" className="flex items-center gap-3 mb-6 group">
              <span className="font-bold tracking-tight text-2xl text-white">
                HOST<span className="font-light text-gray-50">CRAFT</span>
              </span>
            </Link>
            <p className="text-gray-50 mb-8 max-w-sm leading-relaxed text-sm">
              Premium infrastructure engineering. We provide bare-metal power with cloud flexibility.
              Registered in India & Singapore.
            </p>

            {/* Live Status Widget */}
            <div className="inline-flex items-center gap-3 px-4 py-2 bg-gray-90 rounded border border-gray-80 hover:border-green-80 transition cursor-help">
              <span className="relative flex h-2 w-2">
                <span className="animate-ping absolute inline-flex h-full w-full rounded-full bg-green-50 opacity-75"></span>
                <span className="relative inline-flex rounded-full h-2 w-2 bg-green-50"></span>
              </span>
              <div className="flex flex-col">
                <span className="text-[10px] font-bold text-gray-50 uppercase tracking-wider leading-none mb-0.5">
                  Network Status
                </span>
                <span className="text-xs font-mono text-green-40 leading-none">ALL SYSTEMS OPERATIONAL</span>
              </div>
            </div>
          </div>

          {/* Links Column 1: Compute (Span 2) */}
          <div className="col-span-1 md:col-span-2">
            <h4 className="font-bold text-white mb-6 uppercase tracking-wider text-xs font-mono">Compute</h4>
            <ul className="space-y-3 text-sm">
              <li>
                <a href="#" className="hover:text-blue-40 transition flex items-center gap-2">
                  <FontAwesomeIcon icon={faChevronRight} className="text-[8px] text-gray-60" />
                  Starter VPS
                </a>
              </li>
              <li>
                <a href="#" className="hover:text-blue-40 transition flex items-center gap-2">
                  <FontAwesomeIcon icon={faChevronRight} className="text-[8px] text-gray-60" />
                  Developer RDP
                </a>
              </li>
              <li>
                <a href="#" className="hover:text-blue-40 transition flex items-center gap-2">
                  <FontAwesomeIcon icon={faChevronRight} className="text-[8px] text-gray-60" />
                  Enterprise Node
                </a>
              </li>
              <li>
                <a href="#" className="hover:text-blue-40 transition flex items-center gap-2">
                  <FontAwesomeIcon icon={faChevronRight} className="text-[8px] text-gray-60" />
                  Storage Blocks
                </a>
              </li>
            </ul>
          </div>

          {/* Links Column 2: Help (Span 2) */}
          <div className="col-span-1 md:col-span-2">
            <h4 className="font-bold text-white mb-6 uppercase tracking-wider text-xs font-mono">Help</h4>
            <ul className="space-y-3 text-sm">
              <li>
                <Link to="/docs" className="hover:text-blue-40 transition flex items-center gap-2">
                  <FontAwesomeIcon icon={faChevronRight} className="text-[8px] text-gray-60" />
                  Docs
                </Link>
              </li>
              <li>
                <Link to="/community" className="hover:text-blue-40 transition flex items-center gap-2">
                  <FontAwesomeIcon icon={faChevronRight} className="text-[8px] text-gray-60" />
                  Community
                </Link>
              </li>
              <li>
                <Link to="/support" className="hover:text-blue-40 transition flex items-center gap-2">
                  <FontAwesomeIcon icon={faChevronRight} className="text-[8px] text-gray-60" />
                  Support
                </Link>
              </li>
            </ul>
          </div>

          {/* Links Column 3: Legal & Newsletter (Span 4) */}
          <div className="col-span-2 md:col-span-4 bg-gray-90/50 p-6 rounded-lg border border-gray-80">
            <h4 className="font-bold text-white mb-4 uppercase tracking-wider text-xs font-mono">Stay Updated</h4>
            <p className="text-xs text-gray-50 mb-4">
              Receive network maintenance alerts and exclusive node restocking news.
            </p>

            <form className="flex gap-2 mb-6">
              <input
                type="email"
                placeholder="support@hostcraft.site"
                className="w-full bg-[#111] border border-gray-70 text-gray-30 px-4 py-2 rounded text-sm focus:border-blue-60 focus:outline-none transition"
              />
              <button className="bg-blue-60 text-white px-4 py-2 rounded font-bold hover:bg-blue-50 transition">
                <FontAwesomeIcon icon={faArrowRight} />
              </button>
            </form>

            <div className="flex gap-4 text-xs font-bold text-gray-50">
              <Link to="/legal/terms" className="hover:text-white underline decoration-gray-60">Terms</Link>
              <Link to="/legal/privacy" className="hover:text-white underline decoration-gray-60">Privacy</Link>
              <Link to="/legal/aup" className="hover:text-white underline decoration-gray-60">AUP</Link>
              <Link to="/legal/refund" className="hover:text-white underline decoration-gray-60">Refund</Link>
            </div>
          </div>
        </div>

        {/* Footer Bottom */}
        <div className="border-t border-gray-80 pt-8 flex flex-col md:flex-row justify-between items-center gap-6">
          {/* Copyright */}
          <div className="text-gray-60 text-xs font-mono">
            &copy; 2026 HostCraft Infrastructure. <span className="hidden sm:inline">|</span> Powering 5,000+ Nodes.
          </div>

          {/* Socials */}
          <div className="flex gap-4">
            <a
              href="https://discord.gg/Xzk5QHKJuC"
              target="_blank"
              rel="noopener noreferrer"
              className="w-8 h-8 rounded bg-gray-90 flex items-center justify-center hover:bg-[#5865F2] hover:text-white transition text-gray-50"
            >
              <FontAwesomeIcon icon={faDiscord} />
            </a>
            <a
              href="https://www.facebook.com/hostcraftcloud"
              target="_blank"
              rel="noopener noreferrer"
              className="w-8 h-8 rounded bg-gray-90 flex items-center justify-center hover:bg-[#1877F2] hover:text-white transition text-gray-50"
            >
              <FontAwesomeIcon icon={faFacebook} />
            </a>
            <a
              href="https://www.instagram.com/abdul.rauf.manj/"
              target="_blank"
              rel="noopener noreferrer"
              className="w-8 h-8 rounded bg-gray-90 flex items-center justify-center hover:bg-[#E4405F] hover:text-white transition text-gray-50"
            >
              <FontAwesomeIcon icon={faInstagram} />
            </a>
          </div>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
