import { Link } from 'react-router-dom';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faArrowLeft, faKey, faTriangleExclamation, faCheck } from '@fortawesome/free-solid-svg-icons';
import Navbar from '../../components/Navbar';
import Footer from '../../components/Footer';

const ResetRootPassword = () => {
  return (
    <div className="pt-14 bg-[#f4f4f4] min-h-screen">
      {/* Hero Section */}
      <header className="py-16 bg-[#161616] border-b border-[#393939] relative overflow-hidden">
        <div
          className="absolute inset-0 z-0 opacity-10 pointer-events-none"
          style={{
            backgroundImage: 'linear-gradient(#ffffff 1px, transparent 1px), linear-gradient(to right, #ffffff 1px, transparent 1px)',
            backgroundSize: '40px 40px'
          }}
        ></div>

        <div className="bx--grid relative z-10">
          <div className="max-w-4xl mx-auto">
            {/* Breadcrumb */}
            <Link
              to="/community"
              className="inline-flex items-center gap-2 text-[#a8a8a8] hover:text-[#0f62fe] mb-6 font-mono text-sm transition"
            >
              <FontAwesomeIcon icon={faArrowLeft} />
              Back to Guides
            </Link>

            <div className="flex items-start gap-6">
              <div className="w-16 h-16 bg-[#8a3ffc]/10 text-[#8a3ffc] rounded-lg flex items-center justify-center flex-shrink-0">
                <FontAwesomeIcon icon={faKey} className="text-2xl" />
              </div>
              <div>
                <span className="text-[10px] font-mono font-bold uppercase tracking-wider bg-[#8a3ffc]/10 text-[#8a3ffc] px-2 py-1 rounded mb-3 inline-block">
                  VPS Management
                </span>
                <h1 className="text-3xl md:text-4xl font-light text-white tracking-tight">
                  Reset Root Password
                </h1>
              </div>
            </div>
          </div>
        </div>
      </header>

      {/* Content */}
      <article className="py-16">
        <div className="bx--grid">
          <div className="max-w-4xl mx-auto">
            <div className="bg-white border border-[#e0e0e0] rounded-xl p-8 md:p-12">
              {/* Warning Box */}
              <div className="bg-[#fff2e8] border border-[#ff832b] rounded-lg p-4 mb-8 flex items-start gap-4">
                <FontAwesomeIcon icon={faTriangleExclamation} className="text-[#ff832b] text-xl flex-shrink-0 mt-0.5" />
                <div>
                  <h4 className="font-bold text-[#5e2900] mb-1">Important Notice</h4>
                  <p className="text-sm text-[#8a3800]">
                    Resetting your password via Virtualizor will require you to use the new credentials immediately.
                    Make sure to save the new password in a secure location.
                  </p>
                </div>
              </div>

              {/* Introduction */}
              <p className="text-[#525252] leading-relaxed mb-8">
                If you've forgotten your root (Linux) or Administrator (Windows) password, you can reset it directly
                from the Virtualizor control panel. This guide will walk you through the process step by step.
              </p>

              {/* Steps */}
              <h2 className="text-xl font-bold text-[#161616] mb-4">Step-by-Step Instructions</h2>

              <div className="space-y-6 mb-8">
                {/* Step 1 */}
                <div className="flex gap-4">
                  <div className="w-8 h-8 bg-[#0f62fe] text-white rounded-full flex items-center justify-center flex-shrink-0 font-bold text-sm">
                    1
                  </div>
                  <div>
                    <h3 className="font-bold text-[#161616] mb-2">Log in to the Client Area</h3>
                    <p className="text-[#525252] text-sm leading-relaxed">
                      Visit <a href="#" className="text-[#0f62fe] hover:underline">portal.hostcraft.xyz</a> and log in
                      with your account credentials. Navigate to <strong>Services → My Services</strong> and click on
                      the VPS you want to manage.
                    </p>
                  </div>
                </div>

                {/* Step 2 */}
                <div className="flex gap-4">
                  <div className="w-8 h-8 bg-[#0f62fe] text-white rounded-full flex items-center justify-center flex-shrink-0 font-bold text-sm">
                    2
                  </div>
                  <div>
                    <h3 className="font-bold text-[#161616] mb-2">Access Virtualizor Panel</h3>
                    <p className="text-[#525252] text-sm leading-relaxed">
                      Click on the <strong>"Manage Server"</strong> or <strong>"Control Panel"</strong> button to open
                      the Virtualizor interface. This is where you can manage all aspects of your VPS.
                    </p>
                  </div>
                </div>

                {/* Step 3 */}
                <div className="flex gap-4">
                  <div className="w-8 h-8 bg-[#0f62fe] text-white rounded-full flex items-center justify-center flex-shrink-0 font-bold text-sm">
                    3
                  </div>
                  <div>
                    <h3 className="font-bold text-[#161616] mb-2">Navigate to Settings</h3>
                    <p className="text-[#525252] text-sm leading-relaxed">
                      In the Virtualizor dashboard, click on <strong>Settings</strong> in the left sidebar, then select
                      <strong> Change Password</strong> or <strong>Root Password</strong>.
                    </p>
                  </div>
                </div>

                {/* Step 4 */}
                <div className="flex gap-4">
                  <div className="w-8 h-8 bg-[#0f62fe] text-white rounded-full flex items-center justify-center flex-shrink-0 font-bold text-sm">
                    4
                  </div>
                  <div>
                    <h3 className="font-bold text-[#161616] mb-2">Enter New Password</h3>
                    <p className="text-[#525252] text-sm leading-relaxed">
                      Enter your new password in the provided field. Make sure it's strong and contains a mix of
                      uppercase, lowercase, numbers, and special characters. Click <strong>Change Password</strong>.
                    </p>
                  </div>
                </div>

                {/* Step 5 */}
                <div className="flex gap-4">
                  <div className="w-8 h-8 bg-[#24a148] text-white rounded-full flex items-center justify-center flex-shrink-0 font-bold text-sm">
                    <FontAwesomeIcon icon={faCheck} />
                  </div>
                  <div>
                    <h3 className="font-bold text-[#161616] mb-2">Done!</h3>
                    <p className="text-[#525252] text-sm leading-relaxed">
                      The password change will take effect immediately. You can now connect to your VPS using the new
                      credentials via RDP (Windows) or SSH (Linux).
                    </p>
                  </div>
                </div>
              </div>

              {/* Tips */}
              <div className="bg-[#f4f4f4] border border-[#e0e0e0] rounded-lg p-6">
                <h3 className="font-bold text-[#161616] mb-3">Pro Tips</h3>
                <ul className="space-y-2 text-sm text-[#525252]">
                  <li className="flex items-start gap-2">
                    <FontAwesomeIcon icon={faCheck} className="text-[#24a148] mt-1" />
                    Use a password manager to store your credentials securely.
                  </li>
                  <li className="flex items-start gap-2">
                    <FontAwesomeIcon icon={faCheck} className="text-[#24a148] mt-1" />
                    If the password reset doesn't work, try using the VNC console for direct access.
                  </li>
                  <li className="flex items-start gap-2">
                    <FontAwesomeIcon icon={faCheck} className="text-[#24a148] mt-1" />
                    For Windows, use at least 12 characters for optimal security.
                  </li>
                </ul>
              </div>

              {/* Related Articles */}
              <div className="mt-8 pt-8 border-t border-[#e0e0e0]">
                <h3 className="font-bold text-[#161616] mb-4">Related Articles</h3>
                <div className="grid sm:grid-cols-2 gap-4">
                  <Link
                    to="/community"
                    className="p-4 border border-[#e0e0e0] rounded-lg hover:border-[#0f62fe] transition group"
                  >
                    <span className="text-sm font-medium text-[#161616] group-hover:text-[#0f62fe]">
                      VNC Console Access
                    </span>
                  </Link>
                  <Link
                    to="/community"
                    className="p-4 border border-[#e0e0e0] rounded-lg hover:border-[#0f62fe] transition group"
                  >
                    <span className="text-sm font-medium text-[#161616] group-hover:text-[#0f62fe]">
                      First RDP Login Guide
                    </span>
                  </Link>
                </div>
              </div>
            </div>
          </div>
        </div>
      </article>
    </div>
  );
};

export default ResetRootPassword;
