import { BrowserRouter as Router, Routes, Route, useLocation } from 'react-router-dom';
import { useEffect } from 'react';

// Components
import Navbar from './components/Navbar';
import Footer from './components/Footer';

// Pages
import Home from './pages/Home';
import Login from './pages/Login';
import Register from './pages/Register';
import Dashboard from './pages/Dashboard';
import PricingVPS from './pages/PricingVPS';
import Docs from './pages/Docs';
import Community from './pages/Community';
import Support from './pages/Support';
import SupportTicket from './pages/SupportTicket';

// Legal Pages
import Terms from './pages/legal/Terms';
import Privacy from './pages/legal/Privacy';
import AUP from './pages/legal/AUP';
import Refund from './pages/legal/Refund';

// Community Articles
import ResetRootPassword from './pages/community/ResetRootPassword';

// Scroll to top on route change
function ScrollToTop() {
  const { pathname } = useLocation();

  useEffect(() => {
    window.scrollTo(0, 0);
  }, [pathname]);

  return null;
}

// Layout wrapper for pages with Navbar and Footer
function MainLayout({ children }) {
  return (
    <>
      <Navbar />
      {children}
      <Footer />
    </>
  );
}

// Layout wrapper for pages without Navbar/Footer (like Login, Register, Dashboard)
function MinimalLayout({ children }) {
  return <>{children}</>;
}

function App() {
  return (
    <Router>
      <ScrollToTop />
      <Routes>
        {/* Auth Pages (no navbar/footer) */}
        <Route
          path="/login"
          element={
            <MinimalLayout>
              <Login />
            </MinimalLayout>
          }
        />
        <Route
          path="/register"
          element={
            <MinimalLayout>
              <Register />
            </MinimalLayout>
          }
        />
        <Route
          path="/dashboard"
          element={
            <MinimalLayout>
              <Dashboard />
            </MinimalLayout>
          }
        />

        {/* Main Pages (with navbar/footer) */}
        <Route
          path="/"
          element={
            <MainLayout>
              <Home />
            </MainLayout>
          }
        />
        <Route
          path="/pricing/vps"
          element={
            <MainLayout>
              <PricingVPS />
            </MainLayout>
          }
        />
        <Route
          path="/docs"
          element={
            <MainLayout>
              <Docs />
            </MainLayout>
          }
        />
        <Route
          path="/community"
          element={
            <MainLayout>
              <Community />
            </MainLayout>
          }
        />
        <Route
          path="/community/reset-root-password"
          element={
            <MainLayout>
              <ResetRootPassword />
            </MainLayout>
          }
        />
        <Route
          path="/support"
          element={
            <MainLayout>
              <Support />
            </MainLayout>
          }
        />
        <Route
          path="/support/ticket"
          element={
            <MainLayout>
              <SupportTicket />
            </MainLayout>
          }
        />

        {/* Legal Pages */}
        <Route
          path="/legal/terms"
          element={
            <MainLayout>
              <Terms />
            </MainLayout>
          }
        />
        <Route
          path="/legal/privacy"
          element={
            <MainLayout>
              <Privacy />
            </MainLayout>
          }
        />
        <Route
          path="/legal/aup"
          element={
            <MainLayout>
              <AUP />
            </MainLayout>
          }
        />
        <Route
          path="/legal/refund"
          element={
            <MainLayout>
              <Refund />
            </MainLayout>
          }
        />

        {/* Catch-all redirect to home */}
        <Route
          path="*"
          element={
            <MainLayout>
              <Home />
            </MainLayout>
          }
        />
      </Routes>
    </Router>
  );
}

export default App;
